<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/vendor/autoload.php';

use Smalot\PdfParser\Parser;

$message = '';
$modalMessage = '';
$isPositiveMessage = false; // Variável para identificar se a mensagem é positiva

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['pdfFile'])) {
    $file = $_FILES['pdfFile']['tmp_name'];

    if (file_exists($file)) {
        try {
            $parser = new Parser();
            $pdf = $parser->parseFile($file);

            $details = $pdf->getDetails();
            $producer = $details['Producer'] ?? 'Não disponível';

            // Lógica para determinar a mensagem do modal
            if ($producer === "iText® 7.0.5 ©2000-2017 iText Group NV (AGPL-version); modified using iText® 5.5.13.3 ©2000-2022 iText Group NV (AGPL-version)") {
                $modalMessage = "Comprovativo verdadeiro foi gerado no Multicaixa Express.";
                $isPositiveMessage = true;
            } elseif ($producer === "iText® 5.5.13.3 ©2000-2022 iText Group NV (AGPL-version)") {
                $modalMessage = "Comprovativo vendadeiro foi gerado pelo Banco.";
                $isPositiveMessage = true;
            } elseif ($producer === "iText 2.1.7 by 1T3XT") {
                $modalMessage = "Comprovativo foi gerado no Banco BIC.";
                $isPositiveMessage = true;
            } elseif ($producer === "mPDF 7.1.9") {
                $modalMessage = "Comprovativo foi gerado no Banco BCI.";
                $isPositiveMessage = true;
            } else {
                $modalMessage = "O documento não foi gerado em um sistema reconhecido.";
                $isPositiveMessage = false;
            }

            $message = "" . htmlspecialchars($modalMessage);
        } catch (Exception $e) {
            $message = "Erro ao processar o arquivo: " . $e->getMessage();
            $isPositiveMessage = false;
        }
    } else {
        $message = "Nenhum arquivo foi encontrado.";
        $isPositiveMessage = false;
    }
} else {
    $message = "Envie um arquivo PDF para verificar.";
    $isPositiveMessage = false;
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <link rel="manifest" href="manifest.json">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verificar comprovativos</title>
    <style>
        /* Estilos gerais */
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 700px;
            margin: 50px auto;
            padding: 20px;
            background: #fff;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
        }
        h1 {
            text-align: center;
            color: #0056b3;
        }
        label {
            display: block;
            margin: 20px 0 10px;
            font-weight: bold;
        }
        input[type="file"] {
            padding: 5px;
            width: 100%;
        }
        button {
            margin-top: 20px;
            padding: 10px 20px;
            border: none;
            background-color: #0056b3;
            color: white;
            border-radius: 4px;
            cursor: pointer;
        }
        button:hover {
            background-color: #003d80;
        }
        .message {
            margin-top: 20px;
            padding: 10px;
            background: #e8f5e9;
            color: #2e7d32;
            border: 1px solid #c8e6c9;
            border-radius: 4px;
        }
        .message.error {
            background: #ffebee;
            color: #c62828;
            border: 1px solid #ffcdd2;
        }
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            justify-content: center;
            align-items: center;
        }
        .modal-content {
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
            text-align: center;
        }
        .modal-content h2 {
            margin: 0 0 10px;
        }
        .modal-content p {
            font-size: 1.2em;
            margin: 10px 0;
        }
        .modal-icon {
            font-size: 3em;
            margin-top: 10px;
        }
        .modal-icon.positive {
            color: green;
        }
        .modal-icon.negative {
            color: red;
        }
        .modal-content button {
            margin-top: 10px;
            padding: 10px 20px;
            border: none;
            background-color: #0056b3;
            color: white;
            border-radius: 4px;
            cursor: pointer;
        }
        .modal-content button:hover {
            background-color: #003d80;
        }
        /* Estilos para a lista */
        ul {
            list-style-type: none;
            padding: 0;
            margin: 20px 0;
        }
        ul li {
            position: relative;
            padding-left: 30px;
            margin-bottom: 10px;
            font-size: 1.1em;
        }
        ul li::before {
            content: '✔️';
            position: absolute;
            left: 0;
            color: green;
            font-size: 1.2em;
        }
    </style>
</head>
<body style="background-color: #0056b3;">
    <div class="container">
        <button id="installButton">Instalar Aplicativo</button>
        <h1>Verificador de comprovativos de PDF</h1>
        <form method="post" enctype="multipart/form-data">
            <label for="pdfFile">Selecione um comprovativo em PDF:</label>
            <input type="file" name="pdfFile" id="pdfFile" accept="application/pdf">
            <button type="submit">Verificar</button>
            <?php if (!empty($message)): ?>
            <div class="message <?= strpos($message, 'Erro') !== false || strpos($message, 'não foi gerado') !== false ? 'error' : '' ?>">
                <?= htmlspecialchars($message) ?>
            </div>
            <?php endif; ?>
            <!-- Lista de comprovativos válidos -->
            <h2>Comprovativos Válidos:</h2>
            <ul>
                <li>Todos comprovativos gerados no Multicaixa Express (independente do banco)</li>
                <li>BAI Direto</li>
                <li>App do Banco BIC</li>
                <li>App do Banco SOL</li>
            </ul>
        </form>
    </div>

    <!-- Modal -->
    <div id="resultModal" class="modal">
        <div class="modal-content">
            <h2>Resultado da Verificação</h2>
            <p><?= $modalMessage ?></p>
            <div class="modal-icon <?= $isPositiveMessage ? 'positive' : 'negative' ?>">
                <?= $isPositiveMessage ? '✔️' : '❌' ?>
            </div>
            <button onclick="closeModal()">Fechar</button>
        </div>
    </div>

    <script>
        // Função para exibir o modal
        function showModal() {
            document.getElementById('resultModal').style.display = 'flex';
        }

        // Função para fechar o modal
        function closeModal() {
            document.getElementById('resultModal').style.display = 'none';
        }

        // Exibir o modal se houver uma mensagem definida
        <?php if (!empty($modalMessage)): ?>
        showModal();
        <?php endif; ?>

        // Script para instalação do PWA
        let deferredPrompt;
        window.addEventListener('beforeinstallprompt', (event) => {
            event.preventDefault();
            deferredPrompt = event;
            document.getElementById('installButton').style.display = 'block';
        });

        document.getElementById('installButton').addEventListener('click', async () => {
            if (deferredPrompt) {
                deferredPrompt.prompt();
                const { outcome } = await deferredPrompt.userChoice;
                console.log(`Resultado da instalação: ${outcome}`);
                deferredPrompt = null;
                document.getElementById('installButton').style.display = 'none';
            }
        });

        // Registrar Service Worker
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', () => {
                navigator.serviceWorker.register('/service-worker.js')
                    .then(registration => {
                        console.log('Service Worker registrado com sucesso:', registration);
                    })
                    .catch(error => {
                        console.error('Falha ao registrar o Service Worker:', error);
                    });
            });
        }
    </script>
</body>
</html>